<?php

/***************************************************************************/
/*
/* 	----------------------------------------------------------------------
/* 						DO NOT EDIT THIS FILE
/*	----------------------------------------------------------------------
/* 
/*  					http://themify.me
/*  				Copyright (C) 2010 Themify
/*
/***************************************************************************/

/* 

	Widgets Coded Primarily By: Jon Raasch
	
	Jon Raasch is a front-end web developer / UI designer with endless love 
	for user experience, performance tuning, jQuery & CSS3. He spends his days
	building client sites, consulting, and developing a variety of free jQuery, 
	JavaScript and WordPress tools. Check out Jon's blog (http://jonraasch.com/blog) 
	or follow him on Twitter @jonraasch.

*/

	///////////////////////////////////////////
	// Feature Posts Class
	///////////////////////////////////////////
	class Themify_Feature_Posts extends WP_Widget {
		
		///////////////////////////////////////////
		// Feature Posts
		///////////////////////////////////////////
		function Themify_Feature_Posts() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'feature-posts', 'description' => 'لیستی از نوشته ها که به صورت اختیاری بر اساس دسته فیلتر شده اند.' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-feature-posts' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-feature-posts', 'wp98 - نوشته های ویژه', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			
			extract( $args );
	
			/* User-selected settings. */
			$title 			= apply_filters('widget_title', $instance['title'] );
			$category 		= $instance['category'];
			$show_count 	= $instance['show_count'];
			$show_date 		= $instance['show_date'] ? true : false;
			$show_thumb 	= $instance['show_thumb'] ? true : false;
			$show_excerpt 	= $instance['show_excerpt'] ? true : false;
			$excerpt_length = $instance['excerpt_length'];
			$show_title 	= $instance['hide_title'] ? false : true;
	
			/* Before widget (defined by themes). */
			echo $before_widget;
			
			/* Title of widget (before and after defined by themes). */
			if ( $title )
				echo $before_title . $title . $after_title;
			
			echo '<ul class="feature-posts-list">';
			
			$query_opts = apply_filters('themify_query', array(
				'posts_per_page' => $show_count,
				'post_type' => 'post'
			));
			if ( $category ) $query_opts['cat'] = $category;
			
			query_posts($query_opts);			
			if ( have_posts() ) : while ( have_posts() ) : the_post();
				echo '<li>';
					
					if ( $show_thumb ) {
						themify_image('ignore=true&w='.$instance['thumb_width'].'&h='.$instance['thumb_height'].'&before=<a href="'.get_permalink().'">&after=</a>&class=post-img');
					}
							
					if ( $show_title ) echo '<a href="' . get_permalink() . '" class="feature-posts-title">' . get_the_title() . '</a> <br />';
					
					if ( $show_date ) echo '<small>' . get_the_time('M d, Y') . '</small> <br />';
					
					if ( $show_excerpt ) {
						$the_excerpt = get_the_excerpt();
						
						if($excerpt_length != "") {
						// cut to character limit
						$the_excerpt = substr( $the_excerpt, 0, $excerpt_length );
						
						// cut to last space
						$the_excerpt = substr( $the_excerpt, 0, strrpos( $the_excerpt, ' '));
						}
						
						echo '<span class="post-excerpt">' . $the_excerpt . '</span>';
					}
				echo '</li>';
				endwhile; else:
				endif;
				
				//Reset query_posts
				wp_reset_query();			
			echo '</ul>';
	
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
		
		///////////////////////////////////////////
		// Update
		///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['category'] = $new_instance['category'];
			$instance['show_count'] = $new_instance['show_count'];
			$instance['show_date'] = $new_instance['show_date'];
			$instance['show_thumb'] = $new_instance['show_thumb'];
			$instance['show_excerpt'] = $new_instance['show_excerpt'];
			$instance['hide_title'] = $new_instance['hide_title'];
			$instance['thumb_width'] = $new_instance['thumb_width'];
			$instance['thumb_height'] = $new_instance['thumb_height'];
			$instance['excerpt_length'] = $new_instance['excerpt_length'];
	
			return $instance;
		}
		
		///////////////////////////////////////////
		// Form
		///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'آخرین نوشته ها', 'category' => 0, 'show_count' => 5, 'show_date' => false, 'show_thumb' => false, 'show_excerpt' => false, 'hide_title' => false, 'thumb_width' => 50, 'thumb_height' => 50, 'excerpt_length' => 55 );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان:</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'category' ); ?>">دسته ها:</label>
				<select id="<?php echo $this->get_field_id( 'category' ); ?>" name="<?php echo $this->get_field_name( 'category' ); ?>">
					<option value="0" <?php if ( !$instance['category'] ) echo 'selected="selected"'; ?>>همه</option>
					<?php
					$categories = get_categories(array('type' => 'post'));
					
					foreach( $categories as $cat ) {
						echo '<option value="' . $cat->cat_ID . '"';
						
						if ( $cat->cat_ID == $instance['category'] ) echo  ' selected="selected"';
						
						echo '>' . $cat->cat_name . ' (' . $cat->category_count . ')';
						
						echo '</option>';
					}
					?>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>">نمایش:</label>
				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" /> نوشته
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['hide_title'], 'on' ); ?> id="<?php echo $this->get_field_id( 'hide_title' ); ?>" name="<?php echo $this->get_field_name( 'hide_title' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'hide_title' ); ?>">مخفی کردن عنوان نوشته</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_date'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_date' ); ?>">نمایش تاریخ نوشته</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_thumb' ); ?>" name="<?php echo $this->get_field_name( 'show_thumb' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_thumb' ); ?>">نمایش تصویر بندانگشتی نوشته</label>
			</p>
			
			<?php
			// only allow thumbnail dimensions if GD library supported
			if ( function_exists('imagecreatetruecolor') ) {
			?>
			<p>
			   <label for="<?php echo $this->get_field_id( 'thumb_width' ); ?>">اندازه تصویر بندانگشتی</label> <input type="text" id="<?php echo $this->get_field_id( 'thumb_width' ); ?>" name="<?php echo $this->get_field_name( 'thumb_width' ); ?>" value="<?php echo $instance['thumb_width']; ?>" size="3" /> x <input type="text" id="<?php echo $this->get_field_id( 'thumb_height' ); ?>" name="<?php echo $this->get_field_name( 'thumb_height' ); ?>" value="<?php echo $instance['thumb_height']; ?>" size="3" />
			</p>
			<?php
			}
			?>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_excerpt'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>">نمایش چکیده نوشته</label>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'excerpt_length' ); ?>">محدودیت حروف چکیده:</label>
				<input id="<?php echo $this->get_field_id( 'excerpt_length' ); ?>" name="<?php echo $this->get_field_name( 'excerpt_length' ); ?>" value="<?php echo $instance['excerpt_length']; ?>" size="5" /><br /><small>(خالی = توضیحات کامل)</small>
			</p>
			
			<?php
		}
	}
	
	///////////////////////////////////////////
	// List Pages Class
	///////////////////////////////////////////
	class Themify_List_Pages extends WP_Widget {
		
		///////////////////////////////////////////
		// List Pages
		///////////////////////////////////////////
		function Themify_List_Pages() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'list-pages', 'description' => 'قهرستی از برگه ها' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-list-pages' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-list-pages', 'wp98 - فهرست برگه ها', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			extract( $args );
	
			/* User-selected settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$parent = $instance['parent'];
			$depth = $instance['depth'];
			$orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : false;
			$exclude = isset( $instance['exclude'] ) ? $instance['exclude'] : false;
	
			/* Before widget (defined by themes). */
			echo $before_widget;
	
			/* Title of widget (before and after defined by themes). */
			if ( $title )
				echo $before_title . $title . $after_title;
			
			echo '<ul class="pages-list">';
			
			wp_list_pages(array(
				'child_of'       => $parent,
				'depth'         => $depth,
				'sort_column'   => $orderby,
				'exclude'  => $exclude,
				'title_li' => ''
			));
			
			echo '</ul>';
			
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
		///////////////////////////////////////////
		// Update
		///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['parent'] = $new_instance['parent'];
			$instance['depth'] = $new_instance['depth'];
			$instance['orderby'] = $new_instance['orderby'];
			$instance['exclude'] = $new_instance['exclude'];
	
			return $instance;
		}
		
		///////////////////////////////////////////
		// Form
		///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'برگه ها', 'parent' => '', 'depth' => 0, 'orderby' => 'post_title', 'exclude' => '' );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'parent' ); ?>">مادر:</label>
				<select id="<?php echo $this->get_field_id( 'parent' ); ?>" name="<?php echo $this->get_field_name( 'parent' ); ?>">
					<option value="0" <?php if ( 0 == $instance['parent'] ) echo 'selected="selected"'; ?>>همه</option>
					<?php
					$pages = get_pages();
					
					foreach( $pages as $thepage ) {
						echo '<option value="' . $thepage->ID . '"';
						
						if ( $thepage->ID == $instance['parent'] ) echo  ' selected="selected"';
						
						echo '>' . $thepage->post_title;
						
						echo '</option>';
					}
					?>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'depth' ); ?>">عمق:</label>
				<select id="<?php echo $this->get_field_id( 'depth' ); ?>" name="<?php echo $this->get_field_name( 'depth' ); ?>">
					<option value="0" <?php if ( 0 == $instance['depth'] ) echo 'selected="selected"'; ?>>0 (پیش فرض)</option>
					<option value="1" <?php if ( 1 == $instance['depth'] ) echo 'selected="selected"'; ?>>1</option>
					<option value="2" <?php if ( 2 == $instance['depth'] ) echo 'selected="selected"'; ?>>2</option>
					<option value="3" <?php if ( 3 == $instance['depth'] ) echo 'selected="selected"'; ?>>3</option>
					<option value="4" <?php if ( 4 == $instance['depth'] ) echo 'selected="selected"'; ?>>4</option>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>">مرتب سازی بر اساس:</label>
				<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>">
					<option value="id" <?php if ( 'id' == $instance['orderby'] ) echo 'selected="selected"'; ?>>شناسه</option>
					<option value="menu_order" <?php if ( 'menu_order' == $instance['orderby'] ) echo 'selected="selected"'; ?>>ترتیب منو</option>
					<option value="post_title" <?php if ( 'post_title' == $instance['orderby'] ) echo 'selected="selected"'; ?>>عنوان نوشته</option>
					<option value="post_date" <?php if ( 'post_date' == $instance['orderby'] ) echo 'selected="selected"'; ?>>تاریخ نوشته</option>
					<option value="post_name" <?php if ( 'post_name' == $instance['orderby'] ) echo 'selected="selected"'; ?>>نام نوشته</option>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'exclude' ); ?>">محروم کردن:</label><br />
				<input id="<?php echo $this->get_field_id( 'exclude' ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" value="<?php echo $instance['exclude']; ?>" /><br />
				<small>شناسه برگه ها، با کاما جدا شوند (مانند 5,8)</small>
			</p>
			
			<?php
		}
	}
	
	///////////////////////////////////////////
	// List Categories Class
	///////////////////////////////////////////
	class Themify_List_Categories extends WP_Widget {
		
		///////////////////////////////////////////
		// List Categories
		///////////////////////////////////////////
		function Themify_List_Categories() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'list-categories', 'description' => 'فهرستی از دسته ها' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-list-categories' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-list-categories', 'wp98 - فهرست دسته ها', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			extract( $args );
	
			/* User-selected settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$parent = $instance['parent'];
			$depth = $instance['depth'];
			$orderby = $instance['orderby'];
			$exclude = $instance['exclude'];
			$show_dropdown = isset( $instance['show_dropdown'] ) ? $instance['show_dropdown'] : false;
			$show_counts = isset( $instance['show_counts'] ) ? $instance['show_counts'] : false;
			$show_hierarchy = isset( $instance['show_hierarchy'] ) ? $instance['show_hierarchy'] : false;
	
			/* Before widget (defined by themes). */
			echo $before_widget;
	
			/* Title of widget (before and after defined by themes). */
			if ( $title )
				echo $before_title . $title . $after_title;
			
			$args = array(
					'orderby'       => $orderby,
					'show_count'    => $show_counts,
					'child_of'      => $parent,
					'exclude'       => $exclude,
					'hierarchical'  => $show_hierarchy,
					'depth'         => $depth,
					'title_li'      => ''
				);
			
			if ( $show_dropdown ) {
				$args['show_option_none'] = __('Select Category');
				wp_dropdown_categories($args);
			?>
			
			<script type='text/javascript'>
			/* <![CDATA[ */
				var dropdown = document.getElementById("cat");
				function onCatChange() {
					if ( dropdown.options[dropdown.selectedIndex].value > 0 ) {
						location.href = "<?php echo home_url(); ?>/?cat="+dropdown.options[dropdown.selectedIndex].value;
					}
				}
				dropdown.onchange = onCatChange;
			/* ]]> */
			</script>
			
			<?php
			}
			else {
				echo '<ul class="categories-list">';
				
				wp_list_categories($args);
				
				echo '</ul>';
			}
	
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
		///////////////////////////////////////////
		// Update
		///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['parent'] = $new_instance['parent'];
			$instance['depth'] = $new_instance['depth'];
			$instance['orderby'] = $new_instance['orderby'];
			$instance['exclude'] = $new_instance['exclude'];
			$instance['show_dropdown'] = $new_instance['show_dropdown'];
			$instance['show_counts'] = $new_instance['show_counts'];
			$instance['show_hierarchy'] = $new_instance['show_hierarchy'];
	
			return $instance;
		}
		
		///////////////////////////////////////////
		// Form
		///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'دسته ها', 'parent' => 0, 'depth' => 0, 'orderby' => 'name', 'exclude' => '', 'show_dropdown' => false, 'show_counts' => false, 'show_hierarchy' => true );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان:</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'parent' ); ?>">مادر:</label>
				
				<?php
				wp_dropdown_categories( array(
					'show_option_all' => 'همه',
					'orderby'         => 'name',
					'hierarchical'    => 1,
					'selected'        => $instance['parent'],
					'id'              => $this->get_field_id( 'parent' ),
					'name'            => $this->get_field_name( 'parent' ),
				));
				?>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'depth' ); ?>">عمق:</label>
				<select id="<?php echo $this->get_field_id( 'depth' ); ?>" name="<?php echo $this->get_field_name( 'depth' ); ?>">
					<option value="0" <?php if ( 0 == $instance['depth'] ) echo 'selected="selected"'; ?>>0 (پیش فرض)</option>
					<option value="1" <?php if ( 1 == $instance['depth'] ) echo 'selected="selected"'; ?>>1</option>
					<option value="2" <?php if ( 2 == $instance['depth'] ) echo 'selected="selected"'; ?>>2</option>
					<option value="3" <?php if ( 3 == $instance['depth'] ) echo 'selected="selected"'; ?>>3</option>
					<option value="4" <?php if ( 4 == $instance['depth'] ) echo 'selected="selected"'; ?>>4</option>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>">مرتب سازی بر اساس:</label>
				<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>">
					<option value="id" <?php if ( 'id' == $instance['orderby'] ) echo 'selected="selected"'; ?>>شناسه</option>
					<option value="name" <?php if ( 'name' == $instance['orderby'] ) echo 'selected="selected"'; ?>>نام</option>
					<option value="slug" <?php if ( 'slug' == $instance['orderby'] ) echo 'selected="selected"'; ?>>اسلاگ</option>
					<option value="count" <?php if ( 'count' == $instance['orderby'] ) echo 'selected="selected"'; ?>>شمارش</option>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'exclude' ); ?>">محروم کردن:</label><br />
				<input id="<?php echo $this->get_field_id( 'exclude' ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" value="<?php echo $instance['exclude']; ?>" /><br />
				<small>شناسه دسته ها، با کاما جدا شوند (مانند 5,8))</small>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_dropdown'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_dropdown' ); ?>" name="<?php echo $this->get_field_name( 'show_dropdown' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_dropdown' ); ?>">نمایش به صورت لیست بازشونده</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_counts'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_counts' ); ?>" name="<?php echo $this->get_field_name( 'show_counts' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_counts' ); ?>">نمایش تعداد نوشته ها</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_hierarchy'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_hierarchy' ); ?>" name="<?php echo $this->get_field_name( 'show_hierarchy' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_hierarchy' ); ?>">نمایش سلسله مراتب</label>
			</p>
			
			<?php
		}
	}
	
	///////////////////////////////////////////
	// Recent Comments Class
	///////////////////////////////////////////
	class Themify_Recent_Comments extends WP_Widget {
		
		///////////////////////////////////////////
		// Recent Comments
		///////////////////////////////////////////
		function Themify_Recent_Comments() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'recent-comments', 'description' => 'فهرستی از آخرین دیدگاه های همه نوشته ها' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-recent-comments' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-recent-comments', 'wp98 - آخرین دیدگاه ها', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			extract( $args );
	
			/* User-selected settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$show_count = $instance['show_count'];
			$show_avatar = isset( $instance['show_avatar'] ) ? $instance['show_avatar'] : false;
			$avatar_size = $instance['avatar_size'];
			$excerpt_length = $instance['excerpt_length'];
	
			/* Before widget (defined by themes). */
			echo $before_widget;
	
			/* Title of widget (before and after defined by themes). */
			if ( $title )
				echo $before_title . $title . $after_title;
					
				$comments = get_comments(array(
					'number' => $show_count,
					'status' => 'approve',
					'type' => 'comment'
				));
				
				echo '<ul class="recent-comments-list">';
				
				foreach($comments as $comment) :
					
					$comm_title = get_the_title($comment->comment_post_ID);
					$comm_link = get_comment_link($comment->comment_ID);
				?>
			
			<li>
				<?php
					if ( $show_avatar ) {
						echo '<a href="' . $comm_link . '">' . get_avatar($comment,$size=$avatar_size) . '</a>';
					}
				?>
				<a href="<?php echo($comm_link)?>"><strong class="comment-author"><?php echo($comment->comment_author)?></strong>:</a> <?php echo substr(get_comment_excerpt( $comment->comment_ID ), 0, $excerpt_length); ?>&hellip;
			</li> 
			
				<?php 
				endforeach;
				
				echo '</ul>';
			
	
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
		///////////////////////////////////////////
		// Update
		///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['show_count'] = $new_instance['show_count'];
			$instance['show_avatar'] = $new_instance['show_avatar'];
			$instance['avatar_size'] = $new_instance['avatar_size'];
			$instance['excerpt_length'] = $new_instance['excerpt_length'];
	
			return $instance;
		}
		
		///////////////////////////////////////////
		// Form
		///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'آخرین دیدگاه ها', 'show_count' => 3, 'show_avatar' => false, 'avatar_size' => 32, 'excerpt_length' => 60 );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان:</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>">نمایش:</label>
				<select id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>">
					<?php
					for ( $i = 1; $i < 11; $i++ ) {
						echo '<option' . ( $i == $instance['show_count'] ? ' selected="selected"' : '' ) . '>' . $i . '</option>';
					}
					?>
				</select>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_avatar'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_avatar' ); ?>" name="<?php echo $this->get_field_name( 'show_avatar' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'avatar' ); ?>">نمایش اواتار</label>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'avatar_size' ); ?>">اندازه اواتار:</label>
				<input id="<?php echo $this->get_field_id( 'avatar_size' ); ?>" name="<?php echo $this->get_field_name( 'avatar_size' ); ?>" value="<?php echo $instance['avatar_size']; ?>" size="4" /> px
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'excerpt_length' ); ?>">چکیده دیدگاه</label>
				<input id="<?php echo $this->get_field_id( 'excerpt_length' ); ?>" name="<?php echo $this->get_field_name( 'excerpt_length' ); ?>" value="<?php echo $instance['excerpt_length']; ?>" size="4" /> حرف
			</p>
			
			<?php
		}
	}
	
	///////////////////////////////////////////
	// Banners & Links Class
	///////////////////////////////////////////
	class Themify_Links extends WP_Widget {
		
		///////////////////////////////////////////
		// Themify Links
		///////////////////////////////////////////
		function Themify_Links() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'links', 'description' => 'لیستی از بوک مارک ها' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-links' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-links', 'wp98 - پیوند ها و بنر ها', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			extract( $args );
	
			/* User-selected settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$category = $instance['category'];
			$orderby = $instance['orderby'];
			$show_count = $instance['show_count'];
			$show_thumb = isset( $instance['show_thumb'] ) ? $instance['show_thumb'] : false;
			$show_name = isset( $instance['show_name'] ) ? $instance['show_name'] : false;
			$show_desc = isset( $instance['show_desc'] ) ? $instance['show_desc'] : false;
	
			/* Before widget (defined by themes). */
			echo $before_widget;
	
			/* Title of widget (before and after defined by themes). */
			if ( $title )
				echo $before_title . $title . $after_title;
			
			echo '<ul class="links-list">';
			
			wp_list_bookmarks( array(
				'categorize'        => false,
				'title_li'          => false,
				'orderby'           => $orderby,
				'limit'             => $show_count,
				'category'          => $category,
				'show_images'       => $show_thumb,
				'show_name'         => $show_name,
				'show_description'  => $show_desc
			));
			
			echo '</ul>';
	
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
		///////////////////////////////////////////
		// Update
		///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['category'] = $new_instance['category'];
			$instance['orderby'] = $new_instance['orderby'];
			$instance['show_count'] = $new_instance['show_count'];
			$instance['show_thumb'] = $new_instance['show_thumb'];
			$instance['show_name'] = $new_instance['show_name'];
			$instance['show_desc'] = $new_instance['show_desc'];
	
			return $instance;
		}
		
		///////////////////////////////////////////
		// Form
		///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'پیوند ها', 'category' => '', 'orderby' => 'rand', 'show_count' => 10, 'show_thumb' => false, 'show_name' => false, 'show_desc' => false );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان:</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'category' ); ?>">دسته ها:</label>
				<select id="<?php echo $this->get_field_id( 'category' ); ?>" name="<?php echo $this->get_field_name( 'category' ); ?>">
					<option value="" <?php if ( '' == $instance['category'] ) echo 'selected="selected"'; ?>>همه</option>
					<?php
					$categories = get_categories(array('type' => 'link'));
					
					foreach( $categories as $cat ) {
						echo '<option value="' . $cat->cat_ID . '"';
						
						if ( $cat->cat_ID == $instance['category'] ) echo  ' selected="selected"';
						
						echo '>' . $cat->cat_name . ' (' . $cat->category_count . ')';
						
						echo '</option>';
					}
					?>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>">مرتب سازی براساس</label>
				<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>">
					<option value="id" <?php if ( 'id' == $instance['orderby'] ) echo 'selected="selected"'; ?>>شناسه</option>
					<option value="name" <?php if ( 'name' == $instance['orderby'] ) echo 'selected="selected"'; ?>>نام</option>
					<option value="rating" <?php if ( 'rating' == $instance['orderby'] ) echo 'selected="selected"'; ?>>رتبه</option>
					<option value="rand" <?php if ( 'rand' == $instance['orderby'] ) echo 'selected="selected"'; ?>>تصادفی</option>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>">تعداد:</label>
				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" />
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_thumb' ); ?>" name="<?php echo $this->get_field_name( 'show_thumb' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_thumb' ); ?>">نمایش تصویر پیوند</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_name'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_name' ); ?>" name="<?php echo $this->get_field_name( 'show_name' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_name' ); ?>">نمایش نام پیوند</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_desc'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_desc' ); ?>" name="<?php echo $this->get_field_name( 'show_desc' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_desc' ); ?>">نمایش توضیحات پیوند</label>
			</p>
			
			<?php
		}
	}
	
	/*
		--------------------------------------------------------------------
		Credit
		--------------------------------------------------------------------
		Plugin Name: Twitter for Wordpress
		Version: 1.9.7
		Plugin URI: http://rick.jinlabs.com/code/twitter
		
		--------------------------------------------------------------------
		Notes
		--------------------------------------------------------------------
		- This version of Twitter for Wordpress has been modified
	*/
	
	define('MAGPIE_CACHE_ON', 1); //2.7 Cache Bug
	define('MAGPIE_CACHE_AGE', 180);
	define('MAGPIE_INPUT_ENCODING', 'UTF-8');
	define('MAGPIE_OUTPUT_ENCODING', 'UTF-8');
	
	///////////////////////////////////////////
	// Display Twitter Feed Function
	///////////////////////////////////////////
	function themify_twitter_messages($username = '', $num = 1, $list = false, $update = true, $linked  = '#', $hyperlinks = true, $twitter_users = true, $encode_utf8 = false) {
		include_once(ABSPATH . WPINC . '/rss.php');
		
		$messages = fetch_rss('http://twitter.com/statuses/user_timeline/'.$username.'.rss');
	
		if ($list) echo '<ul class="twitter-list">';
		
		if ($username == '') {
			if ($list) echo '<li>';
			echo 'RSS not configured';
			if ($list) echo '</li>';
		} else {
				if ( empty($messages->items) ) {
					if ($list) echo '<li>';
					echo 'No Twitter messages.';
					if ($list) echo '</li>';
				} else {
			$i = 0;
					foreach ( $messages->items as $message ) {
						$msg = " ".substr(strstr($message['description'],': '), 2, strlen($message['description']))." ";
						if($encode_utf8) $msg = utf8_encode($msg);
						$link = $message['link'];
					
						if ($list) echo '<li class="twitter-item">'; elseif ($num != 1) echo '<p class="twitter-message">';
	
			  if ($hyperlinks) { $msg = themify_twitter_hyperlinks($msg); }
			  if ($twitter_users)  { $msg = themify_twitter_users($msg); }
								
						if ($linked != '' || $linked != false) {
				if($linked == 'all')  { 
				  $msg = '<a href="'.$link.'" class="twitter-link">'.$msg.'</a>';  // Puts a link to the status of each tweet 
				} else if ( $linked ) {
				  $msg = $msg . '<a href="'.$link.'" class="twitter-link">'.$linked.'</a>'; // Puts a link to the status of each tweet
				  
				}
			  } 
	
			  echo $msg;
			  
			  
			if($update) {				
			  $time = strtotime($message['pubdate']);
			  
			  if ( ( abs( time() - $time) ) < 86400 )
				$h_time = sprintf( __('%s ago'), human_time_diff( $time ) );
			  else
				$h_time = date(__('Y/m/d'), $time);
	
			  echo sprintf( __('%s', 'twitter-for-wordpress'),' <em class="twitter-timestamp">' . $h_time . '</em>' );
			 }          
					  
						if ($list) echo '</li>'; elseif ($num != 1) echo '</p>';
					
						$i++;
						if ( $i >= $num ) break;
					}
				}
			}
			if ($list) echo '</ul>';
		}
	
	///////////////////////////////////////////
	// Hyper Link Discovery
	///////////////////////////////////////////
	function themify_twitter_hyperlinks($text) {
		$text = preg_replace('/\b([a-zA-Z]+:\/\/[\w_.\-]+\.[a-zA-Z]{2,6}[\/\w\-~.?=&%#+$*!]*)\b/i',"<a href=\"$1\" class=\"twitter-link\">$1</a>", $text);
		$text = preg_replace('/\b(?<!:\/\/)(www\.[\w_.\-]+\.[a-zA-Z]{2,6}[\/\w\-~.?=&%#+$*!]*)\b/i',"<a href=\"http://$1\" class=\"twitter-link\">$1</a>", $text);    
		$text = preg_replace("/\b([a-zA-Z][a-zA-Z0-9\_\.\-]*[a-zA-Z]*\@[a-zA-Z][a-zA-Z0-9\_\.\-]*[a-zA-Z]{2,6})\b/i","<a href=\"mailto://$1\" class=\"twitter-link\">$1</a>", $text);
		$text = preg_replace('/([\.|\,|\:|\°|\ø|\>|\{|\(]?)#{1}(\w*)([\.|\,|\:|\!|\?|\>|\}|\)]?)\s/i', "$1<a href=\"http://twitter.com/#search?q=$2\" class=\"twitter-link\">#$2</a>$3 ", $text);
		return $text;
	}
	
	///////////////////////////////////////////
	// Twitter Users
	///////////////////////////////////////////
	function themify_twitter_users($text) {
		   $text = preg_replace('/([\.|\,|\:|\°|\ø|\>|\{|\(]?)@{1}(\w*)([\.|\,|\:|\!|\?|\>|\}|\)]?)\s/i', "$1<a href=\"http://twitter.com/$2\" class=\"twitter-user\">@$2</a>$3 ", $text);
		   return $text;
	}     
	
	///////////////////////////////////////////
	// Twitter Class
	///////////////////////////////////////////
	class Themify_Twitter extends WP_Widget {
		
		///////////////////////////////////////////
		// Twitter
		///////////////////////////////////////////
		function Themify_Twitter() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'twitter', 'description' => 'فهرستی از آخرین توییت ها' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-twitter' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-twitter', 'wp98 - توییتر', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			extract( $args );
	
			/* User-selected settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$username = $instance['username'];
			$show_count = $instance['show_count'];
			$hide_timestamp = isset( $instance['hide_timestamp'] ) ? $instance['hide_timestamp'] : false;
			$linked = $instance['hide_url'] ? false : '#';
			$show_follow = isset( $instance['show_follow'] ) ? $instance['show_follow'] : false;
	
			/* Before widget (defined by themes). */
			echo $before_widget;
	
			/* Title of widget (before and after defined by themes). */
			if ( $title )
				echo $before_title . $title . $after_title;
			
			themify_twitter_messages($username, $show_count, true, !$hide_timestamp, $linked);
			
			if ( $show_follow ) echo '<div class="follow-user"><a href="http://twitter.com/' . $username . '">' . $instance['follow_text'] . '</a></div>';
	
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
		///////////////////////////////////////////
		// Update
		///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['username'] = $new_instance['username'];
			$instance['show_count'] = $new_instance['show_count'];
			$instance['hide_timestamp'] = $new_instance['hide_timestamp'];
			$instance['hide_url'] = $new_instance['hide_url'];
			$instance['show_follow'] = $new_instance['show_follow'];
			$instance['follow_text'] = $new_instance['follow_text'];
	
			return $instance;
		}
		
		///////////////////////////////////////////
		// Form
		///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'آخرین توییت ها', 'username' => '', 'show_count' => 10, 'hide_timestamp' => false, 'hide_url' => false, 'show_follow' => true , 'follow_text' => 'مرا دنبال کنید' );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان:</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'username' ); ?>">شناسه توییتر:</label>
				<input id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php echo $instance['username']; ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>">نمایش:</label>
				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="3" /> توییت
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['hide_timestamp'], 'on' ); ?> id="<?php echo $this->get_field_id( 'hide_timestamp' ); ?>" name="<?php echo $this->get_field_name( 'hide_timestamp' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'hide_timestamp' ); ?>">مخفی کردن رمان</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['hide_url'], 'on' ); ?> id="<?php echo $this->get_field_id( 'hide_url' ); ?>" name="<?php echo $this->get_field_name( 'hide_url' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'hide_url' ); ?>">مخفی کردن آدرس توییت</label>
			</p>
			
			<p>
				<input class="checkbox" type="checkbox" <?php checked( $instance['show_follow'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_follow' ); ?>" name="<?php echo $this->get_field_name( 'show_follow' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'show_follow' ); ?>">نمایش دکمه مرا دنبال کنید</label>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'follow_text' ); ?>">متن مرا دنبال کنید:</label>
				<input id="<?php echo $this->get_field_id( 'follow_text' ); ?>" name="<?php echo $this->get_field_name( 'follow_text' ); ?>" value="<?php echo $instance['follow_text']; ?>" />
			</p>
				
			
			<?php
		}
	}
	
	///////////////////////////////////////////
	// Flickr Class
	///////////////////////////////////////////
	class Themify_Flickr extends WP_Widget {
		
		///////////////////////////////////////////
		// Flickr
		///////////////////////////////////////////
		function Themify_Flickr() {
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'flickr', 'description' => 'نمایش آخرین عکس های فلیکر' );
	
			/* Widget control settings. */
			$control_ops = array( 'id_base' => 'themify-flickr' );
	
			/* Create the widget. */
			$this->WP_Widget( 'themify-flickr', 'wp98 - فلیکر', $widget_ops, $control_ops );
		}
		
		///////////////////////////////////////////
		// Widget
		///////////////////////////////////////////
		function widget( $args, $instance ) {
			extract( $args );
	
			/* User-selected settings. */
			$title = apply_filters('widget_title', $instance['title'] );
			$username = $instance['username'];
			$show_count = $instance['show_count'];
	
			/* Before widget (defined by themes). */
			echo $before_widget;
	
			/* Title of widget (before and after defined by themes). */
			if ( $title ) {
				echo $before_title . $title . $after_title;
			}
			
			echo '<div id="flickr_badge_wrapper" class="clearfix">
					<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$show_count.'.&amp;display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user='.$username.'"></script>
				</div>';
	
			/* After widget (defined by themes). */
			echo $after_widget;
		}
		
        ///////////////////////////////////////////
        // Update
        ///////////////////////////////////////////
		function update( $new_instance, $old_instance ) {
			
            $instance = $old_instance;
	
			/* Strip tags (if needed) and update the widget settings. */
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['username'] = $new_instance['username'];
			$instance['show_count'] = $new_instance['show_count'];
	
			return $instance;
		}
		
        ///////////////////////////////////////////
        // Form
        ///////////////////////////////////////////
		function form( $instance ) {
	
			/* Set up some default widget settings. */
			$defaults = array( 'title' => 'آخرین عکس ها', 'username' => '', 'show_count' => 10 );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">عنوان:</label><br />
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />
			</p>
	
			<p>
				<label for="<?php echo $this->get_field_id( 'username' ); ?>">شناسه فلیکر:</label>
				<input id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php echo $instance['username']; ?>" /><br />
				<small>* پیدا کردن شناسه فلیکر شما: <a href="http://www.idgettr.com" target="_blank">idGettr</a></small>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>">نمایش:</label>
				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" /> عکس
			</p>
	
			<?php
		}
	}
	
	///////////////////////////////////////////
	// Register Widgets
	///////////////////////////////////////////
	function themify_register_widgets() {
		register_widget('Themify_Feature_Posts');
		register_widget('Themify_List_Pages');
		register_widget('Themify_List_Categories');
		register_widget('Themify_Recent_Comments');
		register_widget('Themify_Links');
		register_widget('Themify_Twitter');
		register_widget('Themify_Flickr');
	}
	add_action('widgets_init', themify_register_widgets, 1);

?>